/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.files;

import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.files.FilesBrowser;
import amazon.fws.clicommando.files.JarFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByExtensionInJarFilesBrowser
implements Iterator<InputStream>,
FilesBrowser {
    private Iterator<JarEntry> iterator;
    private String currentFilePath;
    private final JarFile jarFile;

    public ByExtensionInJarFilesBrowser(String pathname, String extension) {
        this.jarFile = JarFileUtils.getJarFile(ByExtensionInJarFilesBrowser.class);
        this.createIterator(pathname, extension);
    }

    private void createIterator(String pathname, String extension) {
        List<JarEntry> jarEntries = JarFileUtils.getFilesInDirectory(this.jarFile, pathname, extension);
        this.iterator = jarEntries.iterator();
    }

    public ByExtensionInJarFilesBrowser(String jarFileName, String pathname, String extension) {
        try {
            this.jarFile = new JarFile(jarFileName);
        }
        catch (IOException e) {
            throw new InternalErrorException("Cannot open jar file: " + jarFileName, e);
        }
        this.createIterator(pathname, extension);
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public InputStream next() {
        JarEntry jarEntry = this.iterator.next();
        try {
            this.currentFilePath = this.jarFile.getName() + "!" + jarEntry.getName();
            return this.jarFile.getInputStream(jarEntry);
        }
        catch (IOException e) {
            throw new InternalErrorException("Cannot open jar file entry: " + this.currentFilePath, e);
        }
    }

    @Override
    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    @Override
    public Iterator<InputStream> iterator() {
        return this;
    }
}

