/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.Properties;
import sun.io.CharacterEncoding;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

@Deprecated
public class Converters {
    private static Object lock = Converters.class;
    private static String converterPackageName = null;
    private static String defaultEncoding = null;
    public static final int BYTE_TO_CHAR = 0;
    public static final int CHAR_TO_BYTE = 1;
    private static final String[] converterPrefix = new String[]{"ByteToChar", "CharToByte"};
    private static final int CACHE_SIZE = 3;
    private static final Object DEFAULT_NAME = new Object();
    private static SoftReference<Object[]>[][] classCache = new SoftReference[][]{new SoftReference[3], new SoftReference[3]};

    private Converters() {
    }

    private static void moveToFront(Object[] oa, int i) {
        Object ob = oa[i];
        for (int j = i; j > 0; --j) {
            oa[j] = oa[j - 1];
        }
        oa[0] = ob;
    }

    private static Class<?> cache(int type, Object encoding) {
        Object[] srs = classCache[type];
        for (int i = 0; i < 3; ++i) {
            SoftReference<Object[]> sr = srs[i];
            if (sr == null) continue;
            Object[] oa = sr.get();
            if (oa == null) {
                srs[i] = null;
                continue;
            }
            if (!oa[1].equals(encoding)) continue;
            Converters.moveToFront(srs, i);
            return (Class)oa[0];
        }
        return null;
    }

    private static Class<?> cache(int type, Object encoding, Class<?> c) {
        Object[] srs = classCache[type];
        srs[2] = new SoftReference<Object[]>(new Object[]{c, encoding});
        Converters.moveToFront(srs, 2);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCached(int type, String encoding) {
        Object object = lock;
        synchronized (object) {
            SoftReference<Object[]>[] srs = classCache[type];
            for (int i = 0; i < 3; ++i) {
                SoftReference<Object[]> sr = srs[i];
                if (sr == null) continue;
                Object[] oa = sr.get();
                if (oa == null) {
                    srs[i] = null;
                    continue;
                }
                if (!oa[1].equals(encoding)) continue;
                return true;
            }
            return false;
        }
    }

    private static String getConverterPackageName() {
        String cp = converterPackageName;
        if (cp != null) {
            return cp;
        }
        GetPropertyAction pa = new GetPropertyAction("file.encoding.pkg");
        cp = AccessController.doPrivileged(pa);
        if (cp != null) {
            converterPackageName = cp;
        } else {
            cp = "sun.io";
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultEncodingName() {
        Object object = lock;
        synchronized (object) {
            if (defaultEncoding == null) {
                GetPropertyAction pa = new GetPropertyAction("file.encoding");
                defaultEncoding = AccessController.doPrivileged(pa);
            }
        }
        return defaultEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefaultEncodingName() {
        if (VM.isBooted()) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            defaultEncoding = "ISO-8859-1";
            Properties p = System.getProperties();
            p.setProperty("file.encoding", defaultEncoding);
            System.setProperties(p);
        }
    }

    private static Class<?> getConverterClass(int type, String encoding) throws UnsupportedEncodingException {
        String enc = null;
        if (!encoding.equals("ISO8859_1")) {
            enc = encoding.equals("8859_1") ? "ISO8859_1" : (encoding.equals("ISO8859-1") ? "ISO8859_1" : (encoding.equals("646") ? "ASCII" : CharacterEncoding.aliasName(encoding)));
        }
        if (enc == null) {
            enc = encoding;
        }
        try {
            return Class.forName(Converters.getConverterPackageName() + "." + converterPrefix[type] + enc);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    private static Object newConverter(String enc, Class<?> c) throws UnsupportedEncodingException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnsupportedEncodingException(enc);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedEncodingException(enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newConverter(int type, String enc) throws UnsupportedEncodingException {
        Class<?> c;
        Object object = lock;
        synchronized (object) {
            c = Converters.cache(type, enc);
            if (c == null && !(c = Converters.getConverterClass(type, enc)).getName().equals("sun.io.CharToByteUTF8")) {
                Converters.cache(type, enc, c);
            }
        }
        return Converters.newConverter(enc, c);
    }

    private static Class<?> getDefaultConverterClass(int type) {
        boolean fillCache = false;
        Class<?> c = Converters.cache(type, DEFAULT_NAME);
        if (c != null) {
            return c;
        }
        String enc = Converters.getDefaultEncodingName();
        if (enc != null) {
            fillCache = true;
        } else {
            enc = "ISO8859_1";
        }
        try {
            c = Converters.getConverterClass(type, enc);
            if (fillCache) {
                Converters.cache(type, DEFAULT_NAME, c);
            }
        }
        catch (UnsupportedEncodingException x) {
            try {
                c = Converters.getConverterClass(type, "ISO8859_1");
            }
            catch (UnsupportedEncodingException y) {
                throw new InternalError("Cannot find default " + converterPrefix[type] + " converter class");
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object newDefaultConverter(int type) {
        Class<?> c;
        Object object = lock;
        synchronized (object) {
            c = Converters.getDefaultConverterClass(type);
        }
        try {
            return Converters.newConverter("", c);
        }
        catch (UnsupportedEncodingException x) {
            throw new InternalError("Cannot instantiate default converter class " + c.getName());
        }
    }
}

