/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import java.io.UnsupportedEncodingException;

public final class BerDecoder
extends Ber {
    private int origOffset;

    public BerDecoder(byte[] buf, int offset, int bufsize) {
        this.buf = buf;
        this.bufsize = bufsize;
        this.origOffset = offset;
        this.reset();
    }

    public void reset() {
        this.offset = this.origOffset;
    }

    public int getParsePosition() {
        return this.offset;
    }

    public int parseLength() throws Ber.DecodeException {
        int lengthbyte = this.parseByte();
        if ((lengthbyte & 0x80) == 128) {
            if ((lengthbyte &= 0x7F) == 0) {
                throw new Ber.DecodeException("Indefinite length not supported");
            }
            if (lengthbyte > 4) {
                throw new Ber.DecodeException("encoding too long");
            }
            if (this.bufsize - this.offset < lengthbyte) {
                throw new Ber.DecodeException("Insufficient data");
            }
            int retval = 0;
            for (int i = 0; i < lengthbyte; ++i) {
                retval = (retval << 8) + (this.buf[this.offset++] & 0xFF);
            }
            if (retval < 0) {
                throw new Ber.DecodeException("Invalid length bytes");
            }
            return retval;
        }
        return lengthbyte;
    }

    public int parseSeq(int[] rlen) throws Ber.DecodeException {
        int seq = this.parseByte();
        int len = this.parseLength();
        if (rlen != null) {
            rlen[0] = len;
        }
        return seq;
    }

    void seek(int i) throws Ber.DecodeException {
        if (this.offset + i > this.bufsize || this.offset + i < 0) {
            throw new Ber.DecodeException("array index out of bounds");
        }
        this.offset += i;
    }

    public int parseByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset++] & 0xFF;
    }

    public int peekByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset] & 0xFF;
    }

    public boolean parseBoolean() throws Ber.DecodeException {
        return this.parseIntWithTag(1) != 0;
    }

    public int parseEnumeration() throws Ber.DecodeException {
        return this.parseIntWithTag(10);
    }

    public int parseInt() throws Ber.DecodeException {
        return this.parseIntWithTag(2);
    }

    private int parseIntWithTag(int tag) throws Ber.DecodeException {
        if (this.parseByte() != tag) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString(this.buf[this.offset - 1] & 0xFF) + " (expected tag " + Integer.toString(tag) + ")");
        }
        int len = this.parseLength();
        if (len > 4) {
            throw new Ber.DecodeException("INTEGER too long");
        }
        if (len > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte fb = this.buf[this.offset++];
        int value = 0;
        value = fb & 0x7F;
        for (int i = 1; i < len; ++i) {
            value <<= 8;
            value |= this.buf[this.offset++] & 0xFF;
        }
        if ((fb & 0x80) == 128) {
            value = -value;
        }
        return value;
    }

    public String parseString(boolean decodeUTF8) throws Ber.DecodeException {
        return this.parseStringWithTag(4, decodeUTF8, null);
    }

    public String parseStringWithTag(int tag, boolean decodeUTF8, int[] rlen) throws Ber.DecodeException {
        String retstr;
        int origOffset = this.offset;
        int st = this.parseByte();
        if (st != tag) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString((byte)st) + " (expected tag " + tag + ")");
        }
        int len = this.parseLength();
        if (len > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        if (len == 0) {
            retstr = "";
        } else {
            byte[] buf2 = new byte[len];
            System.arraycopy(this.buf, this.offset, buf2, 0, len);
            if (decodeUTF8) {
                try {
                    retstr = new String(buf2, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Ber.DecodeException("UTF8 not available on platform");
                }
            }
            try {
                retstr = new String(buf2, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw new Ber.DecodeException("8859_1 not available on platform");
            }
            this.offset += len;
        }
        if (rlen != null) {
            rlen[0] = this.offset - origOffset;
        }
        return retstr;
    }

    public byte[] parseOctetString(int tag, int[] rlen) throws Ber.DecodeException {
        int origOffset = this.offset;
        int st = this.parseByte();
        if (st != tag) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString(st) + " (expected tag " + Integer.toString(tag) + ")");
        }
        int len = this.parseLength();
        if (len > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte[] retarr = new byte[len];
        if (len > 0) {
            System.arraycopy(this.buf, this.offset, retarr, 0, len);
            this.offset += len;
        }
        if (rlen != null) {
            rlen[0] = this.offset - origOffset;
        }
        return retarr;
    }

    public int bytesLeft() {
        return this.bufsize - this.offset;
    }
}

