/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class DigraphNode
implements Cloneable,
Serializable {
    protected Object data;
    protected Set outNodes = new HashSet();
    protected int inDegree = 0;
    private Set inNodes = new HashSet();

    public DigraphNode(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public Iterator getOutNodes() {
        return this.outNodes.iterator();
    }

    public boolean addEdge(DigraphNode node) {
        if (this.outNodes.contains(node)) {
            return false;
        }
        this.outNodes.add(node);
        node.inNodes.add(this);
        node.incrementInDegree();
        return true;
    }

    public boolean hasEdge(DigraphNode node) {
        return this.outNodes.contains(node);
    }

    public boolean removeEdge(DigraphNode node) {
        if (!this.outNodes.contains(node)) {
            return false;
        }
        this.outNodes.remove(node);
        node.inNodes.remove(this);
        node.decrementInDegree();
        return true;
    }

    public void dispose() {
        Object[] inNodesArray = this.inNodes.toArray();
        for (int i = 0; i < inNodesArray.length; ++i) {
            DigraphNode node = (DigraphNode)inNodesArray[i];
            node.removeEdge(this);
        }
        Object[] outNodesArray = this.outNodes.toArray();
        for (int i = 0; i < outNodesArray.length; ++i) {
            DigraphNode node = (DigraphNode)outNodesArray[i];
            this.removeEdge(node);
        }
    }

    public int getInDegree() {
        return this.inDegree;
    }

    private void incrementInDegree() {
        ++this.inDegree;
    }

    private void decrementInDegree() {
        --this.inDegree;
    }
}

