/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.BitSet;

public class VariableGridLayout
extends GridLayout {
    BitSet rowsSet = new BitSet();
    double[] rowFractions = null;
    BitSet colsSet = new BitSet();
    double[] colFractions = null;
    int rows;
    int cols;
    int hgap;
    int vgap;

    public VariableGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
        if (rows != 0) {
            this.rowsSet = new BitSet(rows);
            this.stdRowFractions(rows);
        }
        if (cols != 0) {
            this.colsSet = new BitSet(cols);
            this.stdColFractions(cols);
        }
    }

    public VariableGridLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
        if (rows != 0) {
            this.rowsSet = new BitSet(rows);
            this.stdRowFractions(rows);
        }
        if (cols != 0) {
            this.colsSet = new BitSet(cols);
            this.stdColFractions(cols);
        }
    }

    void stdRowFractions(int nrows) {
        this.rowFractions = new double[nrows];
        for (int i = 0; i < nrows; ++i) {
            this.rowFractions[i] = 1.0 / (double)nrows;
        }
    }

    void stdColFractions(int ncols) {
        this.colFractions = new double[ncols];
        for (int i = 0; i < ncols; ++i) {
            this.colFractions[i] = 1.0 / (double)ncols;
        }
    }

    public void setRowFraction(int rowNum, double fraction) {
        this.rowsSet.set(rowNum);
        this.rowFractions[rowNum] = fraction;
    }

    public void setColFraction(int colNum, double fraction) {
        this.colsSet.set(colNum);
        this.colFractions[colNum] = fraction;
    }

    public double getRowFraction(int rowNum) {
        return this.rowFractions[rowNum];
    }

    public double getColFraction(int colNum) {
        return this.colFractions[colNum];
    }

    void allocateExtraSpace(double[] vec, BitSet userSet) {
        int i;
        double total = 0.0;
        int unallocated = 0;
        for (i = 0; i < vec.length; ++i) {
            if (userSet.get(i)) {
                total += vec[i];
                continue;
            }
            ++unallocated;
        }
        if (unallocated != 0) {
            double space = (1.0 - total) / (double)unallocated;
            for (i = 0; i < vec.length; ++i) {
                if (userSet.get(i)) continue;
                vec[i] = space;
                userSet.set(i);
            }
        }
    }

    void allocateExtraSpace() {
        this.allocateExtraSpace(this.rowFractions, this.rowsSet);
        this.allocateExtraSpace(this.colFractions, this.colsSet);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.insets();
        int ncomponents = parent.countComponents();
        int nrows = this.rows;
        int ncols = this.cols;
        if (nrows > 0) {
            ncols = (ncomponents + nrows - 1) / nrows;
        } else {
            nrows = (ncomponents + ncols - 1) / ncols;
        }
        if (this.rows == 0) {
            this.stdRowFractions(nrows);
        }
        if (this.cols == 0) {
            this.stdColFractions(ncols);
        }
        Dimension size = parent.size();
        int w = size.width - (insets.left + insets.right);
        int h = size.height - (insets.top + insets.bottom);
        w -= (ncols - 1) * this.hgap;
        h -= (nrows - 1) * this.vgap;
        this.allocateExtraSpace();
        int x = insets.left;
        for (int c = 0; c < ncols; ++c) {
            int colWidth = (int)(this.getColFraction(c) * (double)w);
            int y = insets.top;
            for (int r = 0; r < nrows; ++r) {
                int i = r * ncols + c;
                int rowHeight = (int)(this.getRowFraction(r) * (double)h);
                if (i < ncomponents) {
                    parent.getComponent(i).reshape(x, y, colWidth, rowHeight);
                }
                y += rowHeight + this.vgap;
            }
            x += colWidth + this.hgap;
        }
    }

    static String fracsToString(double[] array) {
        String result = "[" + array.length + "]";
        for (int i = 0; i < array.length; ++i) {
            result = result + "<" + array[i] + ">";
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + ",rowFracs=" + VariableGridLayout.fracsToString(this.rowFractions) + ",colFracs=" + VariableGridLayout.fracsToString(this.colFractions) + "]";
    }
}

